#include <stdio.h>
#include <stdlib.h>

typedef struct
{
    long long x, y;
} Tacka;
long long povrsina(Tacka *h, long long n) 
{
    long long p = 0;
    for (long long i = 0; i < n; i++) 
    {
        long long j = (i + 1) % n;
        p += h[i].x * h[j].y;
        p -= h[i].y * h[j].x;
    }
    return abs(p) / 2;
}
int uporedi(const void *a, const void *b) 
{
    Tacka *p1 = (Tacka*)a;
    Tacka *p2 = (Tacka*)b;
    if (p1->x == p2->x) return p1->y - p2->y;
    return p1->x - p2->x;
}
int orjentacija(Tacka p, Tacka q, Tacka r) 
{
    return (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x);
}
int mnogougao(Tacka *p, long long n, Tacka *h) 
{
    qsort(p, n, sizeof(Tacka), uporedi);
    long long k = 0;
    for (long long i = 0; i < n; i++) 
    {
        while (k >= 2 && orjentacija(h[k-2], h[k-1], p[i]) <= 0) 
        {
            k--;
        }
        h[k++] = p[i];
    }
    long long t = k + 1;
    for (long long i = n - 2; i >= 0; i--) 
    {
        while (k >= t && orjentacija(h[k-2], h[k-1], p[i]) <= 0) 
        {
            k--;
        }
        h[k++] = p[i];
    }

    return k - 1;
}
int main() 
{
    long long n;
    scanf("%lld", &n);
    Tacka p[n];
    for (long long i = 0; i < n; i++) 
    {
        scanf("%lld", &p[i].x);
        scanf("%lld", &p[i].y);
    }
    Tacka h1[n];
    long long h2 = mnogougao(p, n, h1);
    long long min = povrsina(h1, h2);
    for (long long i = 0; i < n; i++) 
    {
        Tacka p1[n-1];
        long long id = 0;
        for (long long j = 0; j < n; j++) 
        {
            if (j != i) 
            {
                p1[id++] = p[j];
            }
        }
        Tacka h3[n];
        long long h4 = mnogougao(p1, n-1, h3);
        long long pom = povrsina(h3, h4);
        if (pom < min) 
        {
            min = pom;
        }
    }
    printf("%lld\n", (long long)min);
    return 0;
}